/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.literalskyblock.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.latvian.mods.literalskyblock.LSBBlockEntities;
import dev.latvian.mods.literalskyblock.LSBCommon;
import dev.latvian.mods.literalskyblock.client.LevelRendererLSB;
import dev.latvian.mods.literalskyblock.client.SkyBlockEntityRenderer;
import dev.latvian.mods.literalskyblock.integration.IrisCompat;
import java.io.IOException;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="literalskyblock", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LSBClient
extends LSBCommon {
    private static ShaderInstance skyShader;
    private static int skyWidth;
    private static int skyHeight;
    private static TextureTarget skyRenderTarget;
    public static boolean updateSky;
    private static boolean isRenderingSky;
    private static boolean irisLoaded;
    public static final RenderType SKY_RENDER_TYPE;

    public static ShaderInstance getSkyShader() {
        return skyShader;
    }

    public static void setSkyShader(ShaderInstance shader) {
        skyShader = shader;
    }

    private static void setSkyTexture() {
        if (skyRenderTarget != null) {
            RenderSystem.m_157453_((int)0, (int)skyRenderTarget.m_83975_());
        } else {
            RenderSystem.m_157453_((int)0, (int)0);
        }
    }

    private static void noop() {
    }

    public static void renderSky(RenderLevelLastEvent event) {
        if (isRenderingSky) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int ww = window.m_85441_();
        int wh = window.m_85442_();
        if (ww <= 0 || wh <= 0) {
            return;
        }
        boolean update = false;
        if (skyRenderTarget == null || skyWidth != ww || skyHeight != wh) {
            update = true;
            skyWidth = ww;
            skyHeight = wh;
        }
        if (update) {
            if (skyRenderTarget != null) {
                skyRenderTarget.m_83930_();
            }
            skyRenderTarget = new TextureTarget(skyWidth, skyHeight, true, Minecraft.f_91002_);
        }
        if (irisLoaded) {
            IrisCompat.preRender(mc.f_91060_);
        }
        mc.f_91063_.m_172775_(false);
        skyRenderTarget.m_83947_(true);
        isRenderingSky = true;
        RenderTarget mainRenderTarget = mc.m_91385_();
        LSBClient.renderActualSky(mc, event);
        isRenderingSky = false;
        mc.f_91063_.m_172775_(true);
        skyRenderTarget.m_83963_();
        skyRenderTarget.m_83970_();
        mainRenderTarget.m_83947_(true);
        if (irisLoaded) {
            IrisCompat.postRender(mc.f_91060_);
        }
    }

    public static void renderActualSky(Minecraft mc, RenderLevelLastEvent event) {
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float delta = event.getPartialTick();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        LevelRenderer levelRenderer = mc.f_91060_;
        LevelRendererLSB levelRendererLSB = (LevelRendererLSB)levelRenderer;
        GameRenderer gameRenderer = mc.f_91063_;
        Camera camera = gameRenderer.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        LightTexture lightTexture = gameRenderer.m_109154_();
        FogRenderer.m_109018_((Camera)camera, (float)delta, (ClientLevel)mc.f_91073_, (int)mc.f_91066_.m_193772_(), (float)gameRenderer.m_109131_(delta));
        FogRenderer.m_109036_();
        RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
        float renderDistance = gameRenderer.m_109152_();
        boolean hasSpecialFog = mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)cameraPos.f_82479_), Mth.m_14107_((double)cameraPos.f_82481_)) || mc.f_91065_.m_93090_().m_93715_();
        FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)renderDistance, (boolean)hasSpecialFog, (float)delta);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        levelRenderer.m_202423_(poseStack, projectionMatrix, delta, camera, false, () -> FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)renderDistance, (boolean)hasSpecialFog, (float)delta));
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        if (mc.f_91066_.m_92174_() != CloudStatus.OFF) {
            RenderSystem.m_157427_(GameRenderer::m_172838_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            levelRenderer.m_172954_(poseStack, projectionMatrix, delta, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        }
        RenderSystem.m_69458_((boolean)false);
        levelRendererLSB.renderSnowAndRainLSB(lightTexture, delta, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69461_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        FogRenderer.m_109017_();
    }

    @Override
    public void init() {
        irisLoaded = ModList.get().isLoaded("oculus");
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(LSBBlockEntities.SKY_BLOCK.get(), SkyBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(LSBBlockEntities.VOID_BLOCK.get(), SkyBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("literalskyblock", "sky"), DefaultVertexFormat.f_85814_), LSBClient::setSkyShader);
    }

    static {
        skyWidth = -1;
        skyHeight = -1;
        updateSky = false;
        isRenderingSky = false;
        irisLoaded = false;
        SKY_RENDER_TYPE = RenderType.m_173215_((String)"literalskyblock_sky", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(LSBClient::getSkyShader)).m_173290_(new RenderStateShard.EmptyTextureStateShard(LSBClient::setSkyTexture, LSBClient::noop)).m_110691_(false));
    }
}

